<?php
$radar=$_REQUEST['radar'];
$radar=strtoupper($radar);

$datapath="/mnt/remote/www/data/public/noaa/text-byoffice";

/* set up office/radar associations: if new radars are added, their corresponding office needs to go here. */

$Offices=array("AMA" => "KAMA", "DDC" => "KDDC", "DYX" => "KFWD", 
	       "FWS" => "KFWD", "FDR" => "KOUN", "TLX" => "KOUN",
	       "VNX" => "KOUN", "PUX" => "KPUX", "SGF" => "KSGF",
	       "SHV" => "KSHV", "ICT" => "KICT", "INX" => "KTSA",
	       "SRX" => "KTSA", "LZK" => "KLZK", "LBB" => "KLBB");

$myOffice = $Offices[$radar];

$mypath = $datapath . "/" .$myOffice . "/" . "FTM" ;
$myMessage=$myOffice."FTM".$radar;
$filelist=array();
$count=0;  #number of FTMs actually delivered to user

if (is_dir($mypath)) /*get the list of available product files */
	{
	if ($dirhandle = opendir ($mypath))
	   {
	     while (false !== ($nextfile=readdir($dirhandle)))
                   {
		   array_push($filelist,$nextfile);
		   }
	   sort ($filelist);  #current list of files

	   array_shift($filelist);  #get rid of "."
	   array_shift($filelist);  #get rid of ".."
	   $numfiles = count($filelist);

	   for ($i = 1;$i<=$numfiles;$i++)  {

	       $myfile=array_pop($filelist);

	       $myfilepattern=substr($myfile,13,10);
	       if ($myfilepattern == $myMessage)
		   {
		   $DateTime=substr($myfile,0,13);

		   $Year=substr($DateTime,0,4);
		   $Mon=substr($DateTime,4,2);
		   $Day=substr($DateTime,6,2);
		   $Hour=substr($DateTime,8,2);
		   $Minute=substr($DateTime,10,2);
		
		   $ProdTime=gmmktime($Hour,$Minute,0,$Mon,$Day,$Year);

		   $LabelTime=strftime("<B><CENTER>Free Text Message from $radar at: %a %b %e %Y  %I:%M %p Central Time</CENTER></B> \n ",$ProdTime);


		   /* only print out FTMs that are less than ~ 7 days old 
		   (i.e., 86400 secs/day not considering UTC conversions */

		   $ProductAge=time()-$ProdTime;
		   if ($ProductAge < 86400*7)
		   {
		   
		      if (filesize($mypath."/".$myfile)>0)
		      {
		      echo $LabelTime;
	
		      $FileHandle=fopen($mypath."/".$myfile,"r");
		      while (!feof($FileHandle))
		        {
		        $Line=fgets($FileHandle);
		        echo "$Line<BR>";
		        }
		     fclose ($FileHandle);
		     $count++;
	             echo "<HR>";
		      }

	           }


		   }


	

	   }

           }
		
		if ($count==0)
		{
		  echo "No Current Messages from $radar.";
		}
		

	}
	else
	{
	?>
	No Available Free Text Messages.
	<?php
	}

