<html>

<?php

//display severe wx climo graphics for severe winds, tornadoes, hail, and any severe weather based on date//

//By:  Dale Morris
//  August 21, 2002

//  Arguments:  type -- which type of graphic to display (wind, torn, hail, anysev)
//	      date -- date to search.  If blank, use current date.  If passed, date should be of form mmdd




//error checking on input variables .. first check the type and then process date //

if (($type <> "anysev") AND ($type <> "wind") AND ($type <> "hail") AND ($type <> "torn"))
{

print "<B>Error!  Invalid type...should be anysev, wind, torn, or hail\n";
exit();
}


{

// check mm and dd to see if they are within acceptable limits

if ($date <> "")
   {

   $dd=substr($date,2,2);
   $mm=substr($date,0,2);
   if (($mm < 1) || ($mm > 12))
      {
      print "<B>Error!  Invalid date/month...\n";
      exit();
      }

   if (($dd < 1) || ($dd > 31))
      {
      print "Error!  Invalid date/day...\n";
      exit();
      }
 }

// if no $date given, get system date/time and process into mmdd //

if ($date == "")
  { 

   $date_time = getdate (time());
   $mday=$date_time["mday"];   //numeric day of month//
   $mon=$date_time["mon"];     //numeric month//

   if ($mon < 10)  
      {
      $date = "0".$mon;
      }
   else
      {
      $date = $mon;
      }

   if ($mday < 10)  
      {
      $date = $date. "0".$mday;
      }
      else
      {
      $date = $date. $mday;
      }

    }

   $DIR = opendir($type);
   $filelist = array();
   while ($file = readdir($DIR)) 
      {
      if ($file != "." && $file != "..")
	 {
	 array_push ($filelist,$file);
	 }

      }
   closedir ($DIR);

   sort($filelist);

   // find the appropriate file to display.  will do this by using the doy (day of year) and filedoy 
   $monthdays=array(0,31,59,90,120,151,181,212,243,273,304,334);  //# of days that's elapsed from Jan 1 to beginning of month
   $monthnames=array("January","February","March","April","May","June","July","August","September","October","November","December");

   $typename=array("torn"=>"Tornadoes", 
		   "hail"=>"Severe Hail", 
		   "wind"=>"Severe Wind", 
		   "anysev"=>"Any Severe Weather");

   // calculate the doy //

   $dd=substr($date,2,2);
   $mm=substr($date,0,2);

   if ($mm >1)
      {
      $mydoy=$monthdays[$mm-1]+$dd;
      }
   else
      {
      $mydoy=$dd;
      }


   // foreach file, calculate its doy and put into array:  file is named type.mmdd.gif //

   $filedoy=array();
   foreach ($filelist as $myFile)
      {
      $posn=strpos($myFile,".");
      $Filemm=substr($myFile,$posn+1,2);
      $Filedd=substr($myFile,$posn+3,2);

      if ($Filemm>1)
	{
	$tempdoy=$monthdays[$Filemm-1]+$Filedd;
	}
	else
	{
	$tempdoy=$Filedd;
	}
      array_push ($filedoy,$tempdoy);
      }

   //now file $mydoy in the $filedoy array so we can make amatch

   $firstDoy=array_shift($filedoy);
   $firstFile=array_shift($filelist);
   $found="false";

   while (($filedoy) && ($found == "false"))
    {
     $secondDoy=array_shift($filedoy);
     $secondFile=array_shift($filelist);
     if (($firstDoy <= $mydoy) && ($secondDoy >= $mydoy))
	{
	$found="true";
	$ShowFile=$firstFile;
	if ($secondDoy == $mydoy)
	   {$ShowFile=$secondFile;}
        }
     else
	{
	$firstDoy=$secondDoy;
	$firstFile=$secondFile;
	}
    }

    //special case for dates in last week of year
    if ($found == "false")
       {
       $ShowFile=$secondFile;
       }

//html goes here //


?>

<HEAD>

<?php
$myindex=$mm-1;
print "<TITLE>Severe Weather Climatology Maps: $typename[$type] on $monthnames[$myindex] $dd</TITLE>";

?>
</HEAD>


<IMG SRC="/data/threat/menu.gif" WIDTH=575 HEIGHT=22 BORDER=0 USEMAP="#home">
<MAP NAME="home">
  <AREA COORDS="0,0,163,16" HREF="http://www.ocs.ou.edu" TARGET="_top">
  <AREA COORDS="496,0,534,16" HREF="/" TARGET="_top">
  <AREA COORDS="535,0,580,16" HREF="/search.html" TARGET="_top">
</MAP>


<TABLE bgcolor="black" CELLSPACING=0 CELLPADDING=0 border=0>
<TR><TD width=600>
<FONT FACE="Times" COLOR="White" Point-size="12"><CENTER><B>
<?php
print "Probability of $typename[$type] with 25 miles of a point on $monthnames[$myindex] $dd";
?>

</B></CENTER><FONT>
</TD></TR>

<TR><TD width=600>
<?php
print "<IMG SRC=$type/$ShowFile>";
?>

</TD></TR>
<TR><TD width=600>
<FONT FACE="Times" COLOR="White" Point-size="8">Courtesy Harold Brooks, National Severe Storms Laboratory</FONT>

</TD></TR>
</TABLE>
<?php


}  

?>


<BR>
<IMG SRC="/data/threat/bluebar.gif">
<BR>
<FONT POINT-SIZE="10">
<B>OK-FIRST Project</B></FONT></BR>
<FONT SIZE="-2">
	<A HREF=http://www.ocs.ou.edu>Oklahoma Climatological Survey</A>,
			100 East Boyd Street, Suite 1210,
			Norman, OK 73019.
			<BR>
			Copyright &copy; 2002 Oklahoma Climatological Survey. All Rights Reserved.<BR>Send comments or questions concerning OK-FIRST to 
<A HREF=mailto:dmorris@ou.edu>dmorris@ou.edu</A></FONT>

</html>
