<?php
header("content-type: text/wxml");
$datasource = "http://$SERVER_NAME/cgi-bin/basic/getmts.cgi?site=$site&hours=$hours";
?>

<WxML>
<plugin legend="true"/>
      <graph bgcolor="#EEEEEE">
        <time timeZone="Central"/>
<?php if (preg_match('/TAIR|TS10|TDEW|temps/',$product)) { ?>                
        <axis units="fahr"/>
<?php } ?>
<?php if (preg_match('/RAIN/',$product)) { ?>                
		<axis units="inch" low="0" high="6"/>
<?php } ?>
<?php if (preg_match('/RELH/',$product)) { ?>                
		<axis units="prct"/>
<?php } ?>
<?php if (preg_match('/PRES/',$product)) { ?>                
		<axis units="inhg"/>
<?php } ?>
<?php if (preg_match('/WSPD|WMAX|winds/',$product)) { ?>                
		<axis units="mph"/>
<?php } ?>
<?php if (preg_match('/WDIR|winds/',$product)) { ?>                
		<axis units="degr" low="0" high="360"/>
<?php } ?>
<?php if (preg_match('/SRAD/',$product)) { ?>                
		<axis units="wpsm"/>
<?php } ?>

		
<?php if (preg_match('/TAIR|temps/',$product)) { ?>        
<series visible="true">
	<data src="<?php echo $datasource ?>" param="TAIR" units="fahr" network="Oklahoma Mesonet"/>
	<lineStyle color="#FF0000" width="1"/>
	<pointStyle color="#FF0000" symbol="smallCircle"/>
</series>
<?php } ?>

<?php if (preg_match('/TS10|temps/',$product)) { ?>        
<series visible="true">
	<data src="<?php echo $datasource ?>" param="TS10" units="fahr" network="Oklahoma Mesonet"/>
	<lineStyle color="#CC99FF"/>
</series>
<?php } ?>
 
<?php if (preg_match('/TDEW|temps/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" param="TDEW" units="fahr" network="Oklahoma Mesonet"/>
	<lineStyle color="#339933" width="2"/>
</series>
<?php } ?>

<?php if (preg_match('/RAIN/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="RAIN" units="inch"/>
	<lineStyle color="#6699FF" width="1"/>
</series>
<?php } ?>

<?php if (preg_match('/RELH/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="RELH" units="prct"/>
	<lineStyle color="#000099" width="1"/>
</series>
<?php } ?>		
		
<?php if (preg_match('/PRES/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="PRES" units="inhg"/>
	<lineStyle color="#00CCCC" width="2"/>
</series>		
<?php } ?>			     

<?php if (preg_match('/WSPD|winds/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="WSPD" units="mph"/>
	<lineStyle color="#3366FF" width="2"/>
</series>
<?php } ?>			     

<?php if (preg_match('/WMAX|winds/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="WMAX" units="mph"/>
	<lineStyle color="#FF3300"/>
</series>
<?php } ?>			     

<?php if (preg_match('/WDIR|winds/',$product)) { ?>              
<series visible="true">
	<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="WDIR" units="degr"/>
	<pointStyle color="#9933CC" symbol="smallCircle"/>
</series>
<?php } ?>			     

<?php if (preg_match('/SRAD/',$product)) { ?>              
		<series visible="true">
		<data src="<?php echo $datasource ?>" network="Oklahoma Mesonet" param="SRAD" units="wpsm"/>
		<lineStyle color="#FF6600" width="2"/>
		</series>
<?php } ?>
        
      </graph>
</WxML>
