<?php
session_start();
header("content-type: text/wxml");
include('../get_prefs.php');
include('/mnt/remote/www/common/wxcode/common.php');
?>
<WxML>
<plugin legend="left"> 
<map bgcolor="#<?php echo $m_bgcolor ?>" geography="Oklahoma Maps" timeZone="Central" scale="<?php echo $m_scale ?>" latitude="<?php echo $m_lat ?>" longitude="<?php echo $m_lon ?>">

<?php 
if ($numframes > 0) { echo '<pulse interval="900" rate="10"/>'; 
	$dataSource = "http://$SERVER_NAME/cgi-bin/public/fileserver2.cgi?type=mdf&count=".$numframes;
} else {
	$dataSource = "http://$SERVER_NAME/cgi-bin/public/fileserver2.cgi?type=mdf";
} 
?>

<?php if (preg_match('/CTAIR/',$product)) { 			// Gradient TAIR ?>
<gradient visible="true" id="grid">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TAIR" units="fahr" refresh="60"/>
</gradient>
<?php } ?>	

<?php if (preg_match('/CTA9M/',$product)) { 			// Gradient TA9M ?>
<gradient visible="true" id="grid">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TA9M" units="fahr" refresh="60"/>
</gradient>
<?php } ?>	

<?php if (preg_match('/CHEAT/',$product)) { 			// Gradient HEAT ?>
<gradient visible="true" id="grid">
<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="HEAT" units="fahr"/>
<range low="80.0" high="120.0"/>
			<colorTable>
				#AAFF99 #CCFF99 #FFFF99 #FFFF77 #FFFF55
				#FFDD33 #FFCC33 #FFCC11 #FFBB11 #FFAA11
				#FF9911 #EE9911 #EE7711 #CC7711 #CC5511 
				#CC3311 #CC1100 #AA0000 #990000 #770000
				#550000 #330000
			</colorTable>
</gradient>
<?php } ?>	

<?php if (preg_match('/CCHIL/',$product)) { 			// Gradient CHIL ?>
<gradient id="grid">
<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="CHIL" units="fahr" refresh="60"/>
<range low="-60.0" high="50.0"/>
			<colorTable>
				#330033 #550055 #660066 #550055 #771177 
				#993399 #AA55AA #CC66CC #CC77CC #CC99CC 
				#CC99DD #CCAAEE #CCAAFF #CCCCFF #BBBBFF 
				#AAAAFF #9999FF #9999DD #9999CC #7777CC
				#5555CC #5555AA #555599 #333399 #333377
				#335577 #337799 #557799 #5577AA #7799AA 
			</colorTable>
</gradient>
<?php } ?>

<?php if (preg_match('/CWSPD/',$product)) { 			// Gradient WSPD?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="WSPD" units="mph" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CWMAX/',$product)) { 			// Gradient WMAX ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="WMAX" units="mph" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CWS2M/',$product)) { 			// Gradient WS2M ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="WS2M" units="mph" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTDEW/',$product)) { 			// Gradient TDEW ?>
<gradient visible="true" id="grid">
<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TDEW" units="fahr" refresh="60"/>
<range low="0" high="80.0"/>
			<colorTable>
				<?php echo getGradient('110000 993300 EE9911 FFCC33 FFFF77 FFFF77 55DD55 00CC00 003300','256'); ?> 		
			</colorTable>
</gradient>
<?php } ?>

<?php if (preg_match('/CDEWD/',$product)) { 			// Gradient DEWD ?>
<gradient visible="true" id="grid">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="DEWD" units="fahrd" refresh="300"/>
	<range low="0" high="50.0"/>
	<colorTable>
		<?php echo getGradient('003300 00CC00 55DD55 99DD99 FFFF77 FFCC33 EE9911 993300 110000','256'); ?> 		
	</colorTable>
</gradient>
<?php } ?>

<?php if (preg_match('/CRELH/',$product)) { 			// Gradient RELH ?>
<gradient visible="true" id="grid">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="RELH" units="prct" refresh="60"/>
	<range low="0" high="100.0"/>
	<colorTable>
		<?php echo getGradient('110000 993300 EE9911 FFCC33 FFFF77 99DD99 55DD55 00CC00 003300','256'); ?> 		
	</colorTable>
</gradient>
<?php } ?>

<?php if (preg_match('/CPMSL/',$product)) { 			// Gradient PMSL ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="PMSL" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CPRES/',$product)) { 			// Gradient PRES ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="PRES" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CPALT/',$product)) { 			// Gradient PALT ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="PALT" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CRAIN/',$product)) { 			// Gradient RAIN ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="RAIN" units="inch" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CSRAD/',$product)) { 			// Gradient SRAD ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="SRAD" units="wpsm" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTS05/',$product)) { 			// Gradient TS05 ?>
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="TS05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTB05/',$product)) { 			// Gradient TB05 ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="TB05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>			

<?php if (preg_match('/CTS10/',$product)) { 			// Gradient TS10 ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="TS10" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTB10/',$product)) { 			// Gradient TB10 ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="TB10" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTS30/',$product)) {		 	// Gradient TS30 ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="TS30" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CWMAX/',$product)) { 			// Gradient WMAX ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="WMAX" units="mph" refresh="60" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTHTE/',$product)) { // Gradient THTE ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="THTE" units="kelv" refresh="300" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>

<?php if (preg_match('/CTWET/',$product)) { // Gradient TWET ?>			
<gradient visible="true" id="grid">
	<data src="<?php echo $dataSource ?>" param="TWET" units="fahr" refresh="300" network="Oklahoma Mesonet"/>
</gradient>
<?php } ?>



<!--  Mesonet Sites  -->

<site <?php if (preg_match('/[CL]/',$product)) { echo 'visible="false"';} ?>>
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>"/>
	<pointStyle color="#000000" symbol="dot"/>
            <disclosure proximity="15"/> 
</site>	

<?php if ($m_mesonet_sites[1] != '2') { ?>
<observation position="18" <?php if ($m_mesonet_sites[1] == '0') { echo 'visible="false"';} ?>> 
	<data network="Oklahoma Mesonet" param="NAME"/> 
	<textStyle color="#<?php echo $n_mesonet_sites[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation>
<observation position="6" visible="false"> 
	<data network="Oklahoma Mesonet" param="STID"/> 
	<textStyle color="#<?php echo $n_mesonet_sites[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>	

<!--  Major Rivers -->
<?php if ($m_rivers[1] != '2') { ?>
<overlay <?php if ($m_rivers[1] == '0') { echo 'visible="false"';} ?>> 
	<data src="Oklahoma Maps" param="Rivers"/>
	<lineStyle color="#<?php echo $m_rivers[0] ?>" width="1"/>
</overlay>
<?php } ?>

<!--  Interstate Highways  -->
<?php if ($m_interstate[1] != '2') { ?> 
<overlay <?php if ($m_interstate[1] == '0') { echo 'visible="false"';} ?>>
	<data src="Oklahoma Maps" param="Interstate Highways"/>
	<lineStyle color="#<?php echo $m_interstate[0] ?>" width="2"/>
</overlay>
<?php } ?>	

<!--  U.S.  Highways -->
<?php if ($m_us_highways[1] != '2') { ?>
<overlay <?php if ($m_us_highways[1] == '0') { echo 'visible="false"';} ?>> 
	<data src="Oklahoma Maps" param="U.S. Highways"/>
	<lineStyle color="#<?php echo $m_us_highways[0] ?>" width="1"/>
</overlay> 
<?php } ?>	

<!--  State  Highways -->
<?php if ($m_state_highways[1] != '2') { ?>
<overlay <?php if ($m_state_highways[1] == '0') { echo 'visible="false"';} ?>> 
	<data src="Oklahoma Maps" param="State Highways"/>
	<lineStyle color="#<?php echo $m_state_highways[0] ?>" width="1"/>
</overlay> 
<?php } ?>

<!--  County Borders  -->
<?php if ($m_countybdr[1] != '2') { ?>
<overlay <?php if ($m_countybdr[1] == '0') { echo 'visible="false"';} ?>>
	<data src="Oklahoma Maps" param="County Borders"/>
	<lineStyle color="#<?php echo $m_countybdr[0] ?>" width="1"/>
</overlay>
<?php } ?>	

<!--  State Border -->
<overlay visible="true">
	<data src="Oklahoma Maps" param="State Border"/>
	<lineStyle color="#666666" width="2"/>
</overlay>

<!--  Large Cities  -->
<?php if ($m_large_cities[1] != '2') { ?>
<site <?php if ($m_large_cities[1] == '0') { echo 'visible="false"';} ?>> 
	<data network= "Oklahoma Cities"/> 
	<pointStyle color="#<?php echo $m_large_cities[0] ?>" symbol="smallCircle"/>
            <disclosure proximity="15"/> 
</site> 
	<observation <?php if ($m_large_cities[1] == '0') { echo 'visible="false"';} ?> position="18"> 
	<data network= "Oklahoma Cities" param="NAME" /> 
	<textStyle color="#<?php echo $m_large_cities[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation> 
<?php } ?>

<!--  Medium Cities  -->
<?php if ($m_medium_cities[1] != '2') { ?>
<site <?php if ($m_medium_cities[1] == '0') { echo 'visible="false"';} ?>> 
	<data network= "Oklahoma Minor Cities"/> 
	<pointStyle color="#<?php echo $m_medium_cities[0] ?>" symbol="smallCircle"/>
            <disclosure proximity="15"/> 
</site> 
	<observation <?php if ($m_medium_cities[1] == '0') { echo 'visible="false"';} ?> position="18"> 
	<data network= "Oklahoma Minor Cities" param="NAME" /> 
	<textStyle color="#<?php echo $m_medium_cities[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation> 
<?php } ?>

<!--  Small Towns  -->
<?php if ($m_small_cities[1] != '2') { ?>
<site <?php if ($m_small_cities[1] == '0') { echo 'visible="false"';} ?>> 
	<data network= "Oklahoma Towns"/> 
	<pointStyle color="#<?php echo $m_small_cities[0] ?>" symbol="smallCircle"/>
            <disclosure proximity="15"/> 
</site> 
	<observation <?php if ($m_small_cities[1] == '0') { echo 'visible="false"';} ?> position="18"> 
	<data network= "Oklahoma Towns" param="NAME" /> 
	<textStyle color="#<?php echo $m_small_cities[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation> 
<?php } ?>

<!--  County Seats  -->
<?php if ($m_county_seats[1] != '2') { ?>
<site <?php if ($m_county_seats[1] == '0') { echo 'visible="false"';} ?>> 
	<data network= "Oklahoma County Seats"/> 
	<pointStyle color="#<?php echo $m_county_seats[0] ?>" symbol="smallCircle"/>
            <disclosure proximity="15"/> 
</site> 
<observation <?php if ($m_county_seats[1] == '0') { echo 'visible="false"';} ?> position="18"> 
	<data network= "Oklahoma County Seats" param="NAME" /> 
	<textStyle color="#<?php echo $m_county_seats[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation> 
<?php } ?>	

<!--  OK-FIRST Towns  -->
<?php if ($m_okfirst_towns[1] != '2') { ?>
<site <?php if ($m_okfirst_towns[1] == '0') { echo 'visible="false"';} ?>> 
	<data network= "OK-FIRST Towns"/> 
	<pointStyle color="#<?php echo $m_okfirst_towns[0] ?>" symbol="smallCircle"/>
            <disclosure proximity="15"/> 
</site> 
<observation <?php if ($m_okfirst_towns[1] == '0') { echo 'visible="false"';} ?> position="18"> 
	<data network= "OK-FIRST Towns" param="NAME" /> 
	<textStyle color="#<?php echo $m_okfirst_towns[0] ?>" size="8"/>
            <disclosure proximity="15"/> 
</observation> 
<?php } ?>	


<!--  Wind Vectors  -->
<vector <?php if (!preg_match('/^[CL]/',$product) || $product == 'CHIL') { echo 'visible="false"'; } ?> form="u+v">
	<data src="<?php echo $dataSource ?>" param="UWND" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<data src="<?php echo $dataSource ?>" param="VWND" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<lineStyle color="#3333CC" width="0"/>
</vector>			

<!--  Wind Barbs  -->
<barb <?php if (preg_match('/^[CL]/',$product) && $product != 'CHIL') { echo 'visible="false"'; } ?> form="mag+dir">
	<data src="<?php echo $dataSource ?>" param="WSPD" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<data src="<?php echo $dataSource ?>" param="WDIR" units="degr" refresh="60" network="Oklahoma Mesonet"/>
	<lineStyle color="#484848" width="0"/>
            <disclosure proximity="15"/> 
</barb>




	

<!--  Contour TAIR  -->
<?php if (preg_match('/LTAIR/',$product) || $product == "CTAIR") { ?>
<contour>
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TAIR" units="fahr" refresh="60"/>
	<range low="-20.0" high="130.0" interval="5.0"/>
	<lineStyle color="#660000" width="2"/>
	<textStyle style="bold" size="9" color="000000"/>
</contour>
<?php } ?>

<!--  Contour TA9M  -->
<?php if (preg_match('/LTA9M/',$product) || $product == "CTA9M") { ?>
<contour visible="true">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TA9M" units="fahr" refresh="60"/>
	<range low="-20.0" high="130.0" interval="5.0"/>
	<lineStyle color="#660000" width="2"/>
	<textStyle style="bold" size="9" color="000000"/>
</contour>
<?php } ?>

<!--  Contour HEAT  -->
<?php if (preg_match('/LHEAT/',$product) || $product == "CHEAT") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="HEAT" units="fahr" refresh="60" network="Oklahoma Mesonet"/>	
	<range low="80.0" high="120.0" interval="5.0"/>
	<lineStyle color="#FF0000" width="2"/> 
	<textStyle style="bold" size="9" color="#FF0000"/> 
</contour>
<?php } ?>

<!--  Contour CHIL  -->
<?php if (preg_match('/LCHIL/',$product) || $product == "CCHIL") { ?>
<contour visible="true">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="CHIL" units="fahr" refresh="60"/>
	<range low="-60.0" high="50.0" interval="5.0"/>
	<lineStyle color="#0099FF" width="2"/>
	<textStyle style="bold" size="9" color="#0099FF"/>
</contour>
<?php } ?>

<!--  Contour WSPD  -->
<?php if (preg_match('/LWSPD/',$product) || $product == "CWSPD") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="WSPD" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#990066" size="10"/>
	<lineStyle color="#990066" width="2"/>
	<range low="0" high="150.0" interval="5.0"/>
</contour>
<?php } ?>		
		
<!--  Contour WDIR  -->
<?php if (preg_match('/LWDIR/',$product) || $product == "CWDIR") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="WDIR" units="degr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#990033" size="10"/>
	<lineStyle color="#990033" width="2"/>
	<range low="0" high="360.0" interval="15.0"/>
</contour>
<?php } ?>

<!--  Contour WMAX  -->
<?php if (preg_match('/LWMAX/',$product) || $product == "CWMAX") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="WMAX" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#990066" size="10"/>
	<lineStyle color="#990066" width="2"/>
	<range low="0" high="150.0" interval="5.0"/>
</contour>
<?php } ?>

<!--  Contour WS2M  -->
<?php if (preg_match('/LWS2M/',$product) || $product == "CWS2M") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="WS2M" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#990066" size="10"/>
	<lineStyle color="#990066" width="2"/>
	<range low="0" high="150.0" interval="5.0"/>
</contour>
<?php } ?>

<!--  Contour TDEW  -->
<?php if (preg_match('/LTDEW/',$product) || $product == "CTDEW") { ?>
<contour visible="true">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TDEW" units="fahr" refresh="60"/>
	<range low="-20" high="130.0" interval="5.0"/>
	<lineStyle style="bold" color="#006600" width="2"/>
	<textStyle style="bold" size="9" color="#006600"/>
</contour>
<?php } ?>

<!--  Contour RELH  -->
<?php if (preg_match('/LRELH/',$product) || $product == "CRELH") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="RELH" units="prct" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#006600" size="10"/>
	<lineStyle color="#006600" width="2"/>
	<range low="0" high="100.0" interval="5.0"/>
</contour>
<?php } ?>

<!--  Contour PALT  -->
<?php if (preg_match('/LPALT/',$product) || $product == "CPALT") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="PALT" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#323232" size="10"/>
	<lineStyle color="#323232" width="2"/>
	<range low="28.00" high="32.00" interval="0.05"/>
</contour>
<?php } ?>

<!--  Contour PRES  -->
<?php if (preg_match('/LPRES/',$product) || $product == "CPRES") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="PRES" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#323232" size="10"/>
	<lineStyle color="#323232" width="2"/>
	<range low="24.00" high="32.00" interval="0.25"/>
</contour>
<?php } ?>

<!--  Contour RAIN  -->
<?php if (preg_match('/LRAIN/',$product) || $product == "CRAIN") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="RAIN" units="inch" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#000066" size="10"/>
	<lineStyle color="#000066" width="2"/>
	<range low="0" high="20.00" interval="0.25"/>
</contour>
<?php } ?>

<!--  Contour SRAD  -->
<?php if (preg_match('/LSRAD/',$product) || $product == "CSRAD") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="SRAD" units="wpsm" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#993300" size="10"/>
	<lineStyle color="#993300" width="2"/>
	<range low="0" high="1600" interval="50"/>
</contour>
<?php } ?>

<!--  Contour TS05  -->
<?php if (preg_match('/LTS05/',$product) || $product == "CTS05") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="TS05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#006600" size="10"/>
	<lineStyle color="#006600" width="2"/>
	<range low="-30" high="150.00" interval="2"/>
</contour>
<?php } ?>
		
<!--  Contour TB05  -->
<?php if (preg_match('/LTB05/',$product) || $product == "CTB05") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="TB05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#006600" size="10"/>
	<lineStyle color="#006600" width="2"/>
	<range low="-30" high="150.00" interval="2"/>
</contour>
<?php } ?>

<!--  Contour TS10  -->
<?php if (preg_match('/LTS10/',$product) || $product == "CTS10") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="TS10" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#006600" size="10"/>
	<lineStyle color="#006600" width="2"/>
	<range low="-30" high="150.00" interval="2"/>
</contour>
<?php } ?>

<!--  Contour TB10  -->
<?php if (preg_match('/LTB10/',$product) || $product == "CTB10") { ?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="TB05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#006600" size="10"/>
	<lineStyle color="#006600" width="2"/>
	<range low="-30" high="150.00" interval="2"/>
</contour>
<?php } ?>

<?php if (preg_match('/LTS30/',$product) || $product == "CTS30") {			// Contour TS30	?>
<contour visible="true">
	<data src="<?php echo $dataSource ?>" param="TS30" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle style="bold" color="#006600" size="10"/>
	<lineStyle color="#006600" width="2"/>
	<range low="-30" high="150.00" interval="2"/>
</contour>
<?php } ?>

<?php if (preg_match('/LDEWD/',$product) || $product == "CDWED") {					// Contour DEWD	?>
<contour visible="true">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="DEWD" units="fahrd" refresh="300"/>
	<range low="-20.0" high="130.0" interval="5.0"/>
	<lineStyle style="bold" color="#000000" width="2"/>
	<textStyle style="bold" size="10" color="000000"/>
</contour>
<?php } ?>

<?php if (preg_match('/LTWET/',$product) || $product == "CTWET") {					// Contour TWET	?>
<contour visible="true">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TWET" units="fahr" refresh="300"/>
	<range low="-20.0" high="130.0" interval="5.0"/>
	<lineStyle color="#000000" width="2"/>
	<textStyle style="bold" size="10" color="000000"/>
</contour>
<?php } ?>

<?php if (preg_match('/LTHTE/',$product) || $product == "CTHTE") {					// Contour TWET	?>
<contour visible="true">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="THTE" units="kelv" refresh="300"/>
	<range interval="5.0"/>
	<lineStyle color="#000000" width="2"/>
	<textStyle style="bold" size="10" color="000000"/>
</contour>
<?php } ?>




<!--  TS30  -->
<?php if (preg_match('/TS30|soil/',$product) && !preg_match('/[CL]TS30/',$product)) { ?>
		<observation visible="true" position="6">
			<data src="<?php echo $dataSource ?>" param="TS30" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#333333" size="10"/>
            <disclosure proximity="15"/> 
		</observation>	
<?php } ?>

<!--  TB10  -->
<?php if (preg_match('/TB10|soil/',$product) && !preg_match('/[CL]TB10/',$product)) { ?>
		<observation visible="true" position="5">
			<data src="<?php echo $dataSource ?>" param="TB10" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#705C1E" size="10"/>
            <disclosure proximity="15"/> 
		</observation>	
<?php } ?>

<!--  TS10  -->
<?php if (preg_match('/TS10|soil/',$product) && !preg_match('/[CL]TS10/',$product)) { ?>
		<observation visible="true" position="7">
			<data src="<?php echo $dataSource ?>" param="TS10" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#006600" size="10"/>
            <disclosure proximity="15"/> 
		</observation>	
<?php } ?>

<!--  TB05  -->
<?php if (preg_match('/TB05|soil/',$product) && !preg_match('/[CL]TB05/',$product)) { ?>
		<observation visible="true" position="1">
			<data src="<?php echo $dataSource ?>" param="TB05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#BB9933" size="10"/>
            <disclosure proximity="15"/> 
		</observation>
<?php } ?>

<!--  TS05  -->
<?php if (preg_match('/TS05|soil/',$product) && !preg_match('/[CL]TS05/',$product)) { ?>
		<observation visible="true" position="11">
			<data src="<?php echo $dataSource ?>" param="TS05" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#00BB66" size="10"/>
            <disclosure proximity="15"/> 
		</observation>
<?php } ?>


<!--  SRAD  -->
<?php if (preg_match('/SRAD/',$product) && !preg_match('/[CL]SRAD/',$product)) { ?>
		<observation visible="true" position="1">
			<data src="<?php echo $dataSource ?>" param="SRAD" units="wpsm" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#993300" size="10"/>
            <disclosure proximity="15"/> 
		</observation>				
<?php } ?>

<!--  RAIN  -->
<?php if (preg_match('/RAIN|plot/',$product) && !preg_match('/[CL]RAIN/',$product)) { ?>
		<observation visible="true" position="4">
			<data src="<?php echo $dataSource ?>" param="RAIN" units="inch" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#000066" size="10"/>
            <disclosure proximity="15"/> 
		</observation>
<?php } ?>

<!--  PRES  -->
<?php if ($product == "PRES") { ?>
		<observation visible="true" position="1">
			<data src="<?php echo $dataSource ?>" param="PRES" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
			<textStyle color="#000000" size="10"/>
            <disclosure proximity="15"/> 
		</observation>
<?php } ?>

<!--  PALT  -->
<?php if (preg_match('/PALT|plot/',$product) && !preg_match('/[CL]PALT/',$product)) { ?>
<observation visible="true" position="2">
	<data src="<?php echo $dataSource ?>" param="PALT" units="inhg" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#000000" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  RELH  -->
<?php if (preg_match('/RELH/',$product) && !preg_match('/[CL]RELH/',$product)) { ?>
<observation visible="true" position="7">
	<data src="<?php echo $dataSource ?>" param="RELH" units="prct" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#006600" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  TDEW  -->
<?php if (preg_match('/TDEW|plot/',$product) && !preg_match('/[CL]TDEW/',$product)) { ?>
<observation visible="true" position="8">
	<data src="<?php echo $dataSource ?>" param="TDEW" units="fahr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#006600" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  WS2M  -->
<?php if ($product == "WS2M") { ?>
<observation visible="true" position="2">
	<data src="<?php echo $dataSource ?>" param="WS2M" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#990066" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  WMAX  -->
<?php if (preg_match('/WMAX/',$product) && !preg_match('/[CL]WMAX/',$product)) { ?>
<observation visible="true" position="2">
	<data src="<?php echo $dataSource ?>" param="WMAX" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#990066" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  WDIR  -->
<?php if ($product == "WDIR") { ?>
<observation visible="true" position="2">
	<data src="<?php echo $dataSource ?>" param="WDIR" units="degr" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#990033" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  WSPD  -->
<?php if ($product == "WSPD") { ?>
<observation visible="true" position="2">
	<data src="<?php echo $dataSource ?>" param="WSPD" units="mph" refresh="60" network="Oklahoma Mesonet"/>
	<textStyle color="#990066" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  CHIL  -->
<?php if (preg_match('/CHIL/',$product) && !preg_match('/[CL]CHIL/',$product)) { ?>
<observation visible="true" position="0">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="CHIL" units="fahr" refresh="60"/>
	<textStyle style="bold" color="#0099FF" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  HEAT  -->
<?php if (preg_match('/HEAT/',$product) && !preg_match('/[CL]HEAT/',$product)) { ?>
<observation visible="true" position=""> 
	<data src="<?php echo $dataSource ?>" param="HEAT" units="fahr" refresh="60" network="Oklahoma Mesonet"/> 
	<textStyle color="#FF0000" size="10"/> 
            <disclosure proximity="15"/> 
</observation> 
<?php } ?>

<!--  TA9M  -->
<?php if ($product == "TA9M") { ?>
<observation visible="true" position="0">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TA9M" units="fahr" refresh="60"/>
	<textStyle color="#660000" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>

<!--  TAIR  -->
<?php if (preg_match('/TAIR|plot/',$product) && !preg_match('/[CL]TAIR/',$product)) { ?>
<observation visible="true" position="10">
	<data network="Oklahoma Mesonet" src="<?php echo $dataSource ?>" param="TAIR" units="fahr" refresh="60"/>
	<textStyle color="#660000" size="10"/>
            <disclosure proximity="15"/> 
</observation>
<?php } ?>
		
</map>
</plugin>
</WxML> 

 