<?php
session_start();
header("content-type: text/wxml");
require_once('../../../Connections/connPrefs.php');
include('../../get_prefs.php');
?>
<?php
// this is to set up the correct bounds
$bounds = array('BREF1'   => '19',
                'BREF2'   => '19',
                'BREF3'   => '19',
                'BREF4'   => '19',
                'BREF248' => '20',
                'BVEL1'   => '27',
                'BVEL2'   => '27',
                'BVEL3'   => '27',
                'BVEL4'   => '27',
                'CREF8'   => '36',
                'CREF16'  => '38', 
                'CREF'    => '37',
                'ECHO'    => '41',                
                'TOPS'    => '41',
                'SRVEL1'  => '56',
                'SRVEL2'  => '56',
                'SRVEL3'  => '56',
                'SRVEL4'  => '56',
                'VIL'     => '57',
                'LCREF1'  => '65',
                'LCREF2'  => '66',
                'RAIN1'   => '78',
                'RAIN3'   => '79',
                'RAINS'   => '80',
                'LCREF3'  => '90');

?>
<?php
$params = '';
if ($n_scale > 0) { $params = $params . " scale=\"$n_scale\"";}
if ($n_county != '00000') { $params = $params . " latitude=\"$n_lat\" longitude=\"$n_lon\"";}
if (!$detail) { $detail='0'; }
?>
<WxML>
<plugin legend="right" detail="<?echo $detail ?>"> 
<map bgcolor="#<?php echo $bgcolor ?>" timeZone="Central" <?php if ($radar == $n_radar) { echo $params;} ?>>
  <?php if ($numframes != null) { ?>
  <pulse syncTo="qqq"/> 
  <?php } ?>
  <geography> <projection type="polarStereo"/> <center src="NEXRAD Stations" parm="<?php echo $radar ?>"/> 
  <bounds src="NIDS Products" parm="<?php echo $bounds[$product]; ?>"/> </geography> 

  <nids id="qqq">
<?php if ($numframes == null) { ?>  
  <data src="http://<?php echo $SERVER_NAME ?>/cgi-bin/nids/nids_latest_uniNP.cgi?product=<?php echo $product ?>&radar=<?php echo $radar ?>" refresh="60"/>
<?php } else { ?>
  <data src="http://<?php echo $SERVER_NAME ?>/cgi-bin/nids/nids_anim_uniNP.cgi?product=<?php echo $product ?>&radar=<?php echo $radar ?>&numframes=<?php echo $numframes ?>" refresh="60"/>
<?php } ?>
</nids> 


<?php if ($product == 'CREF') { ?>
<storm visible="true">
  <?php if ($numframes == null) { ?>  
  <data src="http://<?php echo $SERVER_NAME ?>/cgi-bin/nids/nids_latest_uniNP.cgi?product=<?php echo $product ?>&radar=<?php echo $radar ?>" refresh="60"/>
  <?php } else { ?>
  <data src="http://<?php echo $SERVER_NAME ?>/cgi-bin/nids/nids_anim_uniNP.cgi?product=<?php echo $product ?>&radar=<?php echo $radar ?>&numframes=<?php echo $numframes ?>" refresh="60"/>
  <?php } ?>
</storm> 
<?php } ?>


<?php
if ($cb == '1') {
?>
		<overlay>
			<data param="County Borders"/>
			<lineStyle color="#<?php echo $n_countybdr[0] ?>" width="1"/>
		</overlay>
<?php } ?>	
		<overlay>
			<data src="National Map" param="State border"/>
			<lineStyle color="#666666" width="2"/>
		</overlay>
<?php
if ($ih == '1') {
?>			
		<overlay name="Interstate Highways"> 
			<data param="Interstate Highways"/>
			<lineStyle color="#<?php echo $n_interstate[0] ?>" width="2"/>
		</overlay>
<?php } ?>
<?php
if ($uh == '1') {
?>			
		<overlay name="U.S. Highways"> 
			<data param="U.S. Highways"/>
			<lineStyle color="#<?php echo $n_us_highways[0] ?>" width="1"/>
		</overlay>
<?php } ?>
<?php
if ($sh == '1') {
?>			
		<overlay name="State Highways"> 
			<data param="State Highways"/>
			<lineStyle color="#<?php echo $n_state_highways[0] ?>" width="1"/>
		</overlay>
<?php } ?>
<?php
if ($mr == '1') {
?>			
		<overlay name="Rivers"> 
			<data param="Rivers"/>
			<lineStyle color="#<?php echo $n_rivers[0] ?>" width="1"/>
		</overlay>
<?php } ?>
<?php
if ($ms == '1') {
?>
		<site visible="true">
			<data network="Oklahoma Mesonet"/>
			<pointStyle color="#<?php echo $n_mesonet_sites[0] ?>" symbol="dot"/>
			<disclosure proximity="35"/>
		</site>
		<observation position="6" visible="true"> 
			<data network="Oklahoma Mesonet" param="STID"/> 
			<textStyle color="#<?php echo $n_mesonet_sites[0] ?>"/>
		</observation>
<?php } ?>
	<observation position="6" visible="true"> 
		<data network="NEXRAD Stations" param="STID"/> 
		<textStyle color="#000000"/>
	</observation>
	<site>
		<data network="NEXRAD Stations"/> 
		<pointStyle color="#000000" symbol="smallCircle"/>
	</site>
<?php if ($lc == '1') { ?>	
	<observation position="18"> 
		<data network="Oklahoma Cities" param="NAME"/>
		<textStyle color="#<?php echo $n_large_cities[0] ?>" size="8"/> 
		<disclosure proximity="50"/>
	</observation>
	<site>
		<data network="Oklahoma Cities"/> 
		<pointStyle color="#<?php echo $n_large_cities[0] ?>" symbol="smallCircle"/>
		<disclosure proximity="50"/> 
	</site>
<?php } ?>
<?php if ($mc == '1') { ?>	
	<observation position="18"> 
		<data network="Oklahoma Minor Cities" param="NAME"/>
		<textStyle color="#<?php echo $n_medium_cities[0] ?>" size="8"/> 
		<disclosure proximity="50"/>
	</observation>
	<site>
		<data network="Oklahoma Minor Cities"/> 
		<pointStyle color="#<?php echo $n_medium_cities[0] ?>" symbol="smallCircle"/>
		<disclosure proximity="50"/> 
	</site>
<?php } ?>
<?php if ($sc == '1') { ?>	
	<observation position="18"> 
		<data network="Oklahoma Towns" param="NAME"/>
		<textStyle color="#<?php echo $n_small_cities[0] ?>" size="8"/> 
		<disclosure proximity="50"/>
	</observation>
	<site>
		<data network="Oklahoma Towns"/> 
		<pointStyle color="#<?php echo $n_small_cities[0] ?>" symbol="smallCircle"/>
		<disclosure proximity="50"/> 
	</site>
<?php } ?>
<?php if ($cs == '1') { ?>	
	<observation position="18"> 
		<data network="Oklahoma County Seats" param="NAME"/>
		<textStyle color="#<?php echo $n_county_seats[0] ?>" size="8"/> 
		<disclosure proximity="50"/>
	</observation>
	<site>
		<data network="Oklahoma County Seats"/> 
		<pointStyle color="#<?php echo $n_county_seats[0] ?>" symbol="smallCircle"/>
		<disclosure proximity="50"/> 
	</site>
<?php } ?>
<?php if ($ot == '1') { ?>	
	<observation position="18"> 
		<data network="OK-FIRST Towns" param="NAME"/>
		<textStyle color="#<?php echo $n_okfirst_towns[0] ?>" size="8"/> 
		<disclosure proximity="50"/>
	</observation>
	<site>
		<data network="OK-FIRST Towns"/> 
		<pointStyle color="#<?php echo $n_okfirst_towns[0] ?>" symbol="smallCircle"/>
		<disclosure proximity="50"/> 
	</site>
<?php } ?>
<?php if ($bounds[$product] == '20') { $high = '240'; } else { $high = '120'; } ?>	
	<rangeRings visible="true"> 
		<centerSite network="NEXRAD Stations" site="<?php echo $radar ?>" units="nmi"/> 
		<range low="0.0" high="<?php echo $high ?>" interval="30.0"/> 
		<lineStyle color="#CC9999" width="0"/> 
	</rangeRings> 
</map>
</plugin>
</WxML> 

 